/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BeamRenderer {
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("textures/entity/end_gateway_beam.png");

    public static void renderLightBeam(PoseStack matrices, MultiBufferSource vertexConsumers, int age, float tick, int minY, int maxY, float[] colors, float alpha, float beamIn, float beamOut) {
        float red = colors[0];
        float green = colors[1];
        float blue = colors[2];
        int maxBY = minY + maxY;
        float delta = maxY < 0 ? tick : -tick;
        float fractDelta = Mth.m_14187_((float)(delta * 0.2f - (float)Mth.m_14143_((float)(delta * 0.1f))));
        float xIn = -beamIn;
        float minV = Mth.m_14036_((float)(fractDelta - 1.0f), (float)0.0f, (float)1.0f);
        float maxV = (float)maxY * (0.5f / beamIn) + minV;
        float rotation = ((float)age + tick) / 25.0f + 6.0f;
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110460_((ResourceLocation)BEAM_TEXTURE, (boolean)true));
        matrices.m_85836_();
        matrices.m_252781_(Axis.f_252436_.m_252961_(-rotation));
        BeamRenderer.renderBeam(matrices, vertexConsumer, red, green, blue, alpha, minY, maxBY, beamIn, 0.0f, 0.0f, beamIn, 0.0f, xIn, xIn, 0.0f, 0.0f, 1.0f, minV, maxV);
        float xOut = -beamOut;
        maxV = (float)maxY + minV;
        BeamRenderer.renderBeam(matrices, vertexConsumer, red, green, blue, alpha, minY, maxBY, xOut, xOut, beamOut, xOut, xOut, beamOut, beamOut, beamOut, 0.0f, 1.0f, minV, maxV);
        matrices.m_85849_();
    }

    private static void renderBeam(PoseStack matrices, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, int minY, int maxY, float x1, float d1, float x2, float d2, float x3, float d3, float x4, float d4, float minU, float maxU, float minV, float maxV) {
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxY, minY, x1, d1, x2, d2, minU, maxU, minV, maxV);
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxY, minY, x4, d4, x3, d3, minU, maxU, minV, maxV);
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxY, minY, x2, d2, x4, d4, minU, maxU, minV, maxV);
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxY, minY, x3, d3, x1, d1, minU, maxU, minV, maxV);
    }

    private static void renderBeam(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, int minY, int maxY, float minX, float minD, float maxX, float maxD, float minU, float maxU, float minV, float maxV) {
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxX, minY, maxD, maxU, minV);
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxX, maxY, maxD, maxU, maxV);
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, minX, maxY, minD, minU, maxV);
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, minX, minY, minD, minU, minV);
    }

    private static void addVertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, float x, float y, float d, float u, float v) {
        vertexConsumer.m_252986_(matrix4f, x, y, d).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

